{*************************************************************}
{                                                             }
{       Borland Delphi Visual Component Library               }
{       InterBase Express core components                     }
{                                                             }
{       Copyright (c) 1998-2005 Borland Software Corporation  }
{                                                             }
{    InterBase Express is based in part on the product        }
{    Free IB Components, written by Gregory H. Deatz for      }
{    Hoagland, Longo, Moran, Dunst & Doukas Company.          }
{    Free IB Components is used under license.                }
{                                                             }
{    Additional code created by Jeff Overcash and used        }
{    with permission.                                         }
{*************************************************************}

unit Borland.Vcl.IBIntf;

{$A8,R-}

interface

uses SysUtils, Windows, IBHeader, IBInstallHeader, IBExternals,
     System.Runtime.InteropServices;

type

  IGDSLibrary = interface
  ['{1D267E8A-B3CE-4673-8D54-3DDAD0B7906B}']  {do not localize}
    procedure LoadIBLibrary;
    function TryIBLoad: Boolean;
    procedure CheckIBLoaded;
    function GetIBClientVersion: Currency;
    function isc_attach_database(status_vector : PISC_STATUS; db_name_length : Short;
                                 db_name : IntPtr; db_handle : PISC_DB_HANDLE;
			                           parm_buffer_length	: Short; parm_buffer : IntPtr): ISC_STATUS;
    function isc_array_gen_sdl2(status_vector : PISC_STATUS; isc_array_desc : PISC_ARRAY_DESC_V2;
                                isc_arg3 : PShort; isc_arg4 : IntPtr; isc_arg5 : PShort): ISC_STATUS;
    function isc_array_get_slice(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE;
                                 trans_handle : PISC_TR_HANDLE; array_id : PISC_QUAD;
                                 descriptor : PISC_ARRAY_DESC; dest_array : IntPtr;
				                         slice_length : ISC_LONG): ISC_STATUS;
    function isc_array_get_slice2(status_vector : PISC_STATUS;
                                 db_handle : PISC_DB_HANDLE; trans_handle : PISC_TR_HANDLE;
                                 array_id : PISC_QUAD; descriptor : PISC_ARRAY_DESC_V2;
                                 dest_array : IntPtr; slice_length : ISC_LONG): ISC_STATUS;
    function isc_array_lookup_bounds(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE;
                                     trans_handle : PISC_TR_HANDLE; table_name, column_name : IntPtr;
				                             descriptor : PISC_ARRAY_DESC): ISC_STATUS;
    function isc_array_lookup_bounds2(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE;
                                      trans_handle : PISC_TR_HANDLE; table_name, column_name : IntPtr;
				                              descriptor : PISC_ARRAY_DESC_V2): ISC_STATUS;
    function isc_array_lookup_desc(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE;
                                   trans_handle : PISC_TR_HANDLE; table_name, column_name : IntPtr;
				                           descriptor : PISC_ARRAY_DESC): ISC_STATUS;
    function isc_array_lookup_desc2(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE;
                                    trans_handle : PISC_TR_HANDLE; table_name, column_name : IntPtr;
                                    descriptor : PISC_ARRAY_DESC_V2): ISC_STATUS;
    function isc_array_set_desc(status_vector : PISC_STATUS; table_name : IntPtr;
                                column_name : IntPtr; sql_dtype, sql_length, sql_dimensions           : PShort;
                                 descriptor : PISC_ARRAY_DESC): ISC_STATUS;
    function isc_array_set_desc2(status_vector : PISC_STATUS; table_name : IntPtr;
				                         column_name : IntPtr; sql_dtype, sql_length, sql_dimensions : PShort;
                                 descriptor : PISC_ARRAY_DESC_V2): ISC_STATUS;
    function isc_array_put_slice(status_vector : PISC_STATUS; db_handle  : PISC_DB_HANDLE;
                                 trans_handle : PISC_TR_HANDLE; array_id : PISC_QUAD;
                                 descriptor : PISC_ARRAY_DESC; source_array : IntPtr;
                                 slice_length : PISC_LONG): ISC_STATUS;
    function isc_array_put_slice2(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE;
                                 trans_handle : PISC_TR_HANDLE; array_id : PISC_QUAD;
                                 descriptor : PISC_ARRAY_DESC_V2; source_array : IntPtr;
                                 slice_length : PISC_LONG): ISC_STATUS;
    procedure isc_blob_default_desc(descriptor : PISC_BLOB_DESC; table_name : PUChar;
                                   column_name : PUChar);
    procedure isc_blob_default_desc2(descriptor : PISC_BLOB_DESC_V2; table_name : PUChar;
                                    column_name : PUChar);
    function isc_blob_gen_bpb(status_vector : PISC_STATUS; to_descriptor, from_descriptor : PISC_BLOB_DESC;
                              bpb_buffer_length : UShort; bpb_buffer : PUChar;
                              bpb_length : PUShort): ISC_STATUS;
    function isc_blob_gen_bpb2(status_vector : PISC_STATUS; to_descriptor, from_descriptor          : PISC_BLOB_DESC_V2;
                               bpb_buffer_length : UShort; bpb_buffer : PUChar;
                               bpb_length  : PUShort): ISC_STATUS;
    function isc_blob_info(status_vector : PISC_STATUS; blob_handle : PISC_BLOB_HANDLE;
				                   item_list_buffer_length : Short; item_list_buffer : IntPtr;
				                   result_buffer_length : Short; result_buffer : IntPtr): ISC_STATUS;
    function isc_blob_lookup_desc(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE;
                                  trans_handle : PISC_TR_HANDLE; table_name, column_name : IntPtr;
                                  descriptor : PISC_BLOB_DESC; global : PUChar): ISC_STATUS;
    function isc_blob_lookup_desc2(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE;
                                   trans_handle : PISC_TR_HANDLE; table_name, column_name : IntPtr;
                                   descriptor : PISC_BLOB_DESC_v2; global : PUChar): ISC_STATUS;
    function isc_blob_set_desc(status_vector : PISC_STATUS; table_name, column_name : IntPtr;
                               subtype, charset, segment_size : Short; descriptor : PISC_BLOB_DESC): ISC_STATUS;
    function isc_blob_set_desc2(status_vector : PISC_STATUS; table_name, column_name : IntPtr;
                                subtype, charset, segment_size : Short;
                                descriptor : PISC_BLOB_DESC_V2): ISC_STATUS;
    function isc_cancel_blob(status_vector  : PISC_STATUS; blob_handle : PISC_BLOB_HANDLE): ISC_STATUS;
    function isc_cancel_events(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE;
				                       event_id : PISC_LONG): ISC_STATUS;
    function isc_close_blob(status_vector : PISC_STATUS; blob_handle : PISC_BLOB_HANDLE): ISC_STATUS;
    function isc_commit_retaining(status_vector : PISC_STATUS; tran_handle : PISC_TR_HANDLE): ISC_STATUS;
    function isc_commit_transaction(status_vector : PISC_STATUS; tran_handle : PISC_TR_HANDLE): ISC_STATUS;
    function isc_create_blob2(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE;
                              tran_handle : PISC_TR_HANDLE; blob_handle : PISC_BLOB_HANDLE;
                              blob_id : PISC_QUAD; bpb_length : Short; bpb_address : IntPtr): ISC_STATUS;
    function isc_database_info(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE;
                               item_list_buffer_length : Short; item_list_buffer : IntPtr;
                                 result_buffer_length : Short; result_buffer : IntPtr): ISC_STATUS;
    procedure isc_decode_date(ib_date: PISC_QUAD;var tm_date: TCTimeStructure);
    procedure isc_decode_sql_date(ib_date: PISC_DATE;var tm_date: TCTimeStructure);
    procedure isc_decode_sql_time(ib_time: PISC_TIME;var tm_date: TCTimeStructure);
    procedure isc_decode_timestamp(ib_timestamp: PISC_TIMESTAMP; tm_date: PCTimeStructure);
    function isc_detach_database(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE): ISC_STATUS;
    function isc_drop_database(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE): ISC_STATUS;
    function isc_dsql_alloc_statement2(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE;
				                               stmt_handle : PISC_STMT_HANDLE): ISC_STATUS;
    function isc_dsql_describe(status_vector : PISC_STATUS; stmt_handle : PISC_STMT_HANDLE;
                               dialect : UShort; xsqlda : PXSQLDA): ISC_STATUS;
    function isc_dsql_describe_bind(status_vector : PISC_STATUS; stmt_handle : PISC_STMT_HANDLE;
                                 dialect : UShort; xsqlda : PXSQLDA): ISC_STATUS;
    function isc_dsql_execute(status_vector : PISC_STATUS; tran_handle : PISC_TR_HANDLE;
                              stmt_handle : PISC_STMT_HANDLE; dialect : UShort;
                              xsqlda : PXSQLDA): ISC_STATUS;
    function isc_dsql_execute2(status_vector : PISC_STATUS; tran_handle : PISC_TR_HANDLE;
                               stmt_handle : PISC_STMT_HANDLE; dialect : UShort;
                               in_xsqlda, out_xsqlda : PXSQLDA): ISC_STATUS;
    function isc_dsql_execute_immediate(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE;
				                                tran_handle : PISC_TR_HANDLE; length : UShort;
				                                statement : IntPtr; dialect : UShort;
                                        xsqlda : PXSQLDA): ISC_STATUS;
    function isc_dsql_fetch(status_vector : PISC_STATUS; stmt_handle : PISC_STMT_HANDLE;
				                    dialect : UShort; xsqlda : PXSQLDA): ISC_STATUS;
    function isc_dsql_free_statement(status_vector : PISC_STATUS; stmt_handle : PISC_STMT_HANDLE;
                                     options : UShort): ISC_STATUS;
    function isc_dsql_prepare(status_vector : PISC_STATUS; tran_handle : PISC_TR_HANDLE;
                              stmt_handle : PISC_STMT_HANDLE; length : UShort;
                              statement : IntPtr; dialect : UShort;
                              xsqlda : PXSQLDA): ISC_STATUS;
    function isc_dsql_set_cursor_name(status_vector : PISC_STATUS; stmt_handle : PISC_STMT_HANDLE;
                                      cursor_name : IntPtr; _type : UShort): ISC_STATUS;
    function isc_dsql_sql_info(status_vector : PISC_STATUS; stmt_handle : PISC_STMT_HANDLE;
				                       item_length : Short; items : IntPtr; buffer_length : Short;
                               buffer : IntPtr): ISC_STATUS;
    procedure isc_encode_date(var tm_date : TCTimeStructure; ib_date : PISC_QUAD);
    procedure isc_encode_sql_date(var tm_date: TCTimeStructure; ib_date : PISC_DATE);
    procedure isc_encode_sql_time(var tm_date : TCTimeStructure; ib_time : PISC_TIME);
    procedure isc_encode_timestamp(tm_date : PCTimeStructure; ib_timestamp : PISC_TIMESTAMP);
    function isc_event_block(event_buffer : PPChar; result_buffer : PPChar;
				                     id_count : UShort; event_list : array of IntPtr): ISC_LONG;
    procedure isc_event_counts(status_vector : PISC_STATUS; buffer_length  : Short;
				                       event_buffer : IntPtr; result_buffer : IntPtr);
    function isc_free(isc_arg1 : IntPtr): ISC_LONG;
    function isc_get_segment(status_vector : PISC_STATUS; blob_handle : PISC_BLOB_HANDLE;
                             actual_seg_length : PUShort; seg_buffer_length : UShort;
				                     seg_buffer : IntPtr): ISC_STATUS;
    function isc_interprete(buffer : IntPtr; status_vector : PPISC_STATUS): ISC_STATUS;
    function isc_open_blob2(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE;
                            tran_handle : PISC_TR_HANDLE; blob_handle : PISC_BLOB_HANDLE;
				                    blob_id : PISC_QUAD; bpb_length : Short; bpb_buffer : IntPtr): ISC_STATUS;
    function isc_prepare_transaction2(status_vector : PISC_STATUS; tran_handle : PISC_TR_HANDLE;
                                      msg_length : Short; msg : IntPtr): ISC_STATUS;
    function isc_put_segment(status_vector : PISC_STATUS; blob_handle : PISC_BLOB_HANDLE;
				                     seg_buffer_len : UShort; seg_buffer : IntPtr): ISC_STATUS;
    function isc_que_events(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE;
				                    event_id : PISC_LONG; length : Short; event_buffer : IntPtr;
                            event_function : TISC_CALLBACK; event_function_arg        : IntPtr): ISC_STATUS;
    function isc_release_savepoint(status_vector : PISC_STATUS; tran_handle : PISC_TR_HANDLE;
                                   tran_name : IntPtr) : ISC_STATUS;
    function isc_rollback_retaining(status_vector : PISC_STATUS; tran_handle : PISC_TR_HANDLE): ISC_STATUS;
    function isc_rollback_savepoint(status_vector : PISC_STATUS; tran_handle : PISC_TR_HANDLE;
                                    tran_name : IntPtr; Option : UShort) : ISC_STATUS;
    function isc_rollback_transaction(status_vector : PISC_STATUS; tran_handle : PISC_TR_HANDLE): ISC_STATUS;
    function isc_start_multiple(status_vector : PISC_STATUS; tran_handle : PISC_TR_HANDLE;
                                db_handle_count : Short; teb_vector_address : PISC_TEB): ISC_STATUS;
    function isc_start_savepoint(status_vector : PISC_STATUS; tran_handle : PISC_TR_HANDLE;
                                 tran_name : IntPtr): ISC_STATUS;
    function isc_sqlcode(status_vector : PISC_STATUS): ISC_LONG;
    procedure isc_sql_interprete(sqlcode : Short; buffer : IntPtr;
                                 buffer_length : Short);
    function isc_vax_integer(buffer : IntPtr; length : Short): ISC_LONG;
    // Security Functions
    function isc_add_user(status_vector : PISC_STATUS; user_sec_data : PUserSecData): ISC_STATUS;
    function isc_delete_user(status_vector : PISC_STATUS; user_sec_data : PUserSecData): ISC_STATUS;
    function isc_modify_user(status_vector : PISC_STATUS; user_sec_data : PUserSecData): ISC_STATUS;

    // Other OSRI functions
    function isc_prepare_transaction(status_vector         : PISC_STATUS;
                                 tran_handle               : PISC_TR_HANDLE): ISC_STATUS;
   // Other Blob functions
    function BLOB_put(isc_arg1                  : char;
             isc_arg2                  : PBSTREAM): Int;
    function BLOB_get(isc_arg1                  : PBSTREAM): Int;

   // Service manager functions
   function isc_service_attach (status_vector             : PISC_STATUS;
                                 isc_arg2                  : UShort;
                                 isc_arg3                  : IntPtr;
                                 service_handle            : PISC_SVC_HANDLE;
                                 isc_arg5                  : UShort;
                                 isc_arg6                  : IntPtr): ISC_STATUS;
    function isc_service_detach(status_vector             : PISC_STATUS;
                                service_handle            : PISC_SVC_HANDLE): ISC_STATUS;
    function isc_service_query  (status_vector             : PISC_STATUS;
                                 service_handle            : PISC_SVC_HANDLE;
                                 recv_handle               : PISC_SVC_HANDLE;
                                 isc_arg4                  : UShort;
                                 isc_arg5                  : IntPtr;
                                 isc_arg6                  : UShort;
                                 isc_arg7                  : IntPtr;
                                 isc_arg8                  : UShort;
                                 isc_arg9                  : IntPtr): ISC_STATUS;
    function isc_service_start (status_vector             : PISC_STATUS;
                                service_handle            : PISC_SVC_HANDLE;
                                recv_handle               : PISC_SVC_HANDLE;
                                isc_arg4                  : UShort;
                                isc_arg5                  : IntPtr): ISC_STATUS;
    // Client information functions
    procedure isc_get_client_version(buffer : IntPtr);
    function isc_get_client_major_version: Integer;
    function isc_get_client_minor_version: Integer;
    function isc_transaction_info(status_vector            : PISC_STATUS;
                                  tran_handle               : PISC_TR_HANDLE;
                                  item_list_buffer_length   : Short;
                                  item_list_buffer          : IntPtr;
                                  result_buffer_length      : Short;
                                  result_buffer             : IntPtr): ISC_STATUS;
  end;

  TRegisterGDSLibrary = function : IGDSLibrary;
  procedure RegisterGDSLibraryFactory(ARegisterGDSLibrary : TRegisterGDSLibrary);

  function GetGDSLibrary : IGDSLibrary;
{ Library Initialization }

implementation

uses IB, IBXMLHeader, IBXConst;

var
  IBLibraryAvailable : Boolean = False;
  IBXMLLibraryAvailable : Boolean = False;
  IBClientVersion: Currency;
  GDSLibrary : IGDSLibrary;
  FRegisterGDSLibrary : TRegisterGDSLibrary;

type

  TDynamicLibrary = class(TInterfacedObject, IGDSLibrary)
  private
  public
    procedure LoadIBLibrary;
    function TryIBLoad: Boolean;
    procedure CheckIBLoaded;
    function GetIBClientVersion: Currency;

    function isc_attach_database(status_vector : PISC_STATUS; db_name_length : Short;
                                 db_name : IntPtr; db_handle : PISC_DB_HANDLE;
			                           parm_buffer_length	: Short; parm_buffer : IntPtr): ISC_STATUS;
    function isc_array_gen_sdl2(status_vector : PISC_STATUS; isc_array_desc : PISC_ARRAY_DESC_V2;
                                isc_arg3 : PShort; isc_arg4 : IntPtr; isc_arg5 : PShort): ISC_STATUS;
    function isc_array_get_slice(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE;
                                 trans_handle : PISC_TR_HANDLE; array_id : PISC_QUAD;
                                 descriptor : PISC_ARRAY_DESC; dest_array : IntPtr;
				                         slice_length : ISC_LONG): ISC_STATUS;
    function isc_array_get_slice2(status_vector : PISC_STATUS;
                                 db_handle : PISC_DB_HANDLE; trans_handle : PISC_TR_HANDLE;
                                 array_id : PISC_QUAD; descriptor : PISC_ARRAY_DESC_V2;
                                 dest_array : IntPtr; slice_length : ISC_LONG): ISC_STATUS;
    function isc_array_lookup_bounds(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE;
                                     trans_handle : PISC_TR_HANDLE; table_name, column_name : IntPtr;
				                             descriptor : PISC_ARRAY_DESC): ISC_STATUS;
    function isc_array_lookup_bounds2(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE;
                                      trans_handle : PISC_TR_HANDLE; table_name, column_name : IntPtr;
				                              descriptor : PISC_ARRAY_DESC_V2): ISC_STATUS;
    function isc_array_lookup_desc(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE;
                                   trans_handle : PISC_TR_HANDLE; table_name, column_name : IntPtr;
				                           descriptor : PISC_ARRAY_DESC): ISC_STATUS;
    function isc_array_lookup_desc2(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE;
                                    trans_handle : PISC_TR_HANDLE; table_name, column_name : IntPtr;
                                    descriptor : PISC_ARRAY_DESC_V2): ISC_STATUS;
    function isc_array_set_desc(status_vector : PISC_STATUS; table_name : IntPtr;
                                column_name : IntPtr; sql_dtype, sql_length, sql_dimensions           : PShort;
                                 descriptor : PISC_ARRAY_DESC): ISC_STATUS;
    function isc_array_set_desc2(status_vector : PISC_STATUS; table_name : IntPtr;
				                         column_name : IntPtr; sql_dtype, sql_length, sql_dimensions : PShort;
                                 descriptor : PISC_ARRAY_DESC_V2): ISC_STATUS;
    function isc_array_put_slice(status_vector : PISC_STATUS; db_handle  : PISC_DB_HANDLE;
                                 trans_handle : PISC_TR_HANDLE; array_id : PISC_QUAD;
                                 descriptor : PISC_ARRAY_DESC; source_array : IntPtr;
                                 slice_length : PISC_LONG): ISC_STATUS;
    function isc_array_put_slice2(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE;
                                 trans_handle : PISC_TR_HANDLE; array_id : PISC_QUAD;
                                 descriptor : PISC_ARRAY_DESC_V2; source_array : IntPtr;
                                 slice_length : PISC_LONG): ISC_STATUS;
    procedure isc_blob_default_desc(descriptor : PISC_BLOB_DESC; table_name : PUChar;
                                   column_name : PUChar);
    procedure isc_blob_default_desc2(descriptor : PISC_BLOB_DESC_V2; table_name : PUChar;
                                    column_name : PUChar);
    function isc_blob_gen_bpb(status_vector : PISC_STATUS; to_descriptor, from_descriptor : PISC_BLOB_DESC;
                              bpb_buffer_length : UShort; bpb_buffer : PUChar;
                              bpb_length : PUShort): ISC_STATUS;
    function isc_blob_gen_bpb2(status_vector : PISC_STATUS; to_descriptor, from_descriptor          : PISC_BLOB_DESC_V2;
                               bpb_buffer_length : UShort; bpb_buffer : PUChar;
                               bpb_length  : PUShort): ISC_STATUS;
    function isc_blob_info(status_vector : PISC_STATUS; blob_handle : PISC_BLOB_HANDLE;
				                   item_list_buffer_length : Short; item_list_buffer : IntPtr;
				                   result_buffer_length : Short; result_buffer : IntPtr): ISC_STATUS;
    function isc_blob_lookup_desc(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE;
                                  trans_handle : PISC_TR_HANDLE; table_name, column_name : IntPtr;
                                  descriptor : PISC_BLOB_DESC; global : PUChar): ISC_STATUS;
    function isc_blob_lookup_desc2(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE;
                                   trans_handle : PISC_TR_HANDLE; table_name, column_name : IntPtr;
                                   descriptor : PISC_BLOB_DESC_v2; global : PUChar): ISC_STATUS;
    function isc_blob_set_desc(status_vector : PISC_STATUS; table_name, column_name : IntPtr;
                               subtype, charset, segment_size : Short; descriptor : PISC_BLOB_DESC): ISC_STATUS;
    function isc_blob_set_desc2(status_vector : PISC_STATUS; table_name, column_name : IntPtr;
                                subtype, charset, segment_size : Short;
                                descriptor : PISC_BLOB_DESC_V2): ISC_STATUS;
    function isc_cancel_blob(status_vector  : PISC_STATUS; blob_handle : PISC_BLOB_HANDLE): ISC_STATUS;
    function isc_cancel_events(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE;
				                       event_id : PISC_LONG): ISC_STATUS;
    function isc_close_blob(status_vector : PISC_STATUS; blob_handle : PISC_BLOB_HANDLE): ISC_STATUS;
    function isc_commit_retaining(status_vector : PISC_STATUS; tran_handle : PISC_TR_HANDLE): ISC_STATUS;
    function isc_commit_transaction(status_vector : PISC_STATUS; tran_handle : PISC_TR_HANDLE): ISC_STATUS;
    function isc_create_blob2(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE;
                              tran_handle : PISC_TR_HANDLE; blob_handle : PISC_BLOB_HANDLE;
                              blob_id : PISC_QUAD; bpb_length : Short; bpb_address : IntPtr): ISC_STATUS;
    function isc_database_info(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE;
                               item_list_buffer_length : Short; item_list_buffer : IntPtr;
                                 result_buffer_length : Short; result_buffer : IntPtr): ISC_STATUS;
    procedure isc_decode_date(ib_date: PISC_QUAD;var tm_date: TCTimeStructure);
    procedure isc_decode_sql_date(ib_date: PISC_DATE;var tm_date: TCTimeStructure);
    procedure isc_decode_sql_time(ib_time: PISC_TIME;var tm_date: TCTimeStructure);
    procedure isc_decode_timestamp(ib_timestamp: PISC_TIMESTAMP; tm_date: PCTimeStructure);
    function isc_detach_database(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE): ISC_STATUS;
    function isc_drop_database(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE): ISC_STATUS;
    function isc_dsql_alloc_statement2(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE;
				                               stmt_handle : PISC_STMT_HANDLE): ISC_STATUS;
    function isc_dsql_describe(status_vector : PISC_STATUS; stmt_handle : PISC_STMT_HANDLE;
                               dialect : UShort; xsqlda : PXSQLDA): ISC_STATUS;
    function isc_dsql_describe_bind(status_vector : PISC_STATUS; stmt_handle : PISC_STMT_HANDLE;
                                 dialect : UShort; xsqlda : PXSQLDA): ISC_STATUS;
    function isc_dsql_execute(status_vector : PISC_STATUS; tran_handle : PISC_TR_HANDLE;
                              stmt_handle : PISC_STMT_HANDLE; dialect : UShort;
                              xsqlda : PXSQLDA): ISC_STATUS;
    function isc_dsql_execute2(status_vector : PISC_STATUS; tran_handle : PISC_TR_HANDLE;
                               stmt_handle : PISC_STMT_HANDLE; dialect : UShort;
                               in_xsqlda, out_xsqlda : PXSQLDA): ISC_STATUS;
    function isc_dsql_execute_immediate(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE;
				                                tran_handle : PISC_TR_HANDLE; length : UShort;
				                                statement : IntPtr; dialect : UShort;
                                        xsqlda : PXSQLDA): ISC_STATUS;
    function isc_dsql_fetch(status_vector : PISC_STATUS; stmt_handle : PISC_STMT_HANDLE;
				                    dialect : UShort; xsqlda : PXSQLDA): ISC_STATUS;
    function isc_dsql_free_statement(status_vector : PISC_STATUS; stmt_handle : PISC_STMT_HANDLE;
                                     options : UShort): ISC_STATUS;
    function isc_dsql_prepare(status_vector : PISC_STATUS; tran_handle : PISC_TR_HANDLE;
                              stmt_handle : PISC_STMT_HANDLE; length : UShort;
                              statement : IntPtr; dialect : UShort;
                              xsqlda : PXSQLDA): ISC_STATUS;
    function isc_dsql_set_cursor_name(status_vector : PISC_STATUS; stmt_handle : PISC_STMT_HANDLE;
                                      cursor_name : IntPtr; _type : UShort): ISC_STATUS;
    function isc_dsql_sql_info(status_vector : PISC_STATUS; stmt_handle : PISC_STMT_HANDLE;
				                       item_length : Short; items : IntPtr; buffer_length : Short;
                               buffer : IntPtr): ISC_STATUS;
    procedure isc_encode_date(var tm_date : TCTimeStructure; ib_date : PISC_QUAD);
    procedure isc_encode_sql_date(var tm_date: TCTimeStructure; ib_date : PISC_DATE);
    procedure isc_encode_sql_time(var tm_date : TCTimeStructure; ib_time : PISC_TIME);
    procedure isc_encode_timestamp(tm_date : PCTimeStructure; ib_timestamp : PISC_TIMESTAMP);
    function isc_event_block(event_buffer : PPChar; result_buffer : PPChar;
				                     id_count : UShort; event_list : array of IntPtr): ISC_LONG;
    procedure isc_event_counts(status_vector : PISC_STATUS; buffer_length  : Short;
				                       event_buffer : IntPtr; result_buffer : IntPtr);
    function isc_free(isc_arg1 : IntPtr): ISC_LONG;
    function isc_get_segment(status_vector : PISC_STATUS; blob_handle : PISC_BLOB_HANDLE;
                             actual_seg_length : PUShort; seg_buffer_length : UShort;
				                     seg_buffer : IntPtr): ISC_STATUS;
    function isc_interprete(buffer : IntPtr; status_vector : PPISC_STATUS): ISC_STATUS;
    function isc_open_blob2(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE;
                            tran_handle : PISC_TR_HANDLE; blob_handle : PISC_BLOB_HANDLE;
				                    blob_id : PISC_QUAD; bpb_length : Short; bpb_buffer : IntPtr): ISC_STATUS;
    function isc_prepare_transaction2(status_vector : PISC_STATUS; tran_handle : PISC_TR_HANDLE;
                                      msg_length : Short; msg : IntPtr): ISC_STATUS;
    function isc_put_segment(status_vector : PISC_STATUS; blob_handle : PISC_BLOB_HANDLE;
				                     seg_buffer_len : UShort; seg_buffer : IntPtr): ISC_STATUS;
    function isc_que_events(status_vector : PISC_STATUS; db_handle : PISC_DB_HANDLE;
				                    event_id : PISC_LONG; length : Short; event_buffer : IntPtr;
                            event_function : TISC_CALLBACK; event_function_arg        : IntPtr): ISC_STATUS;
    function isc_release_savepoint(status_vector : PISC_STATUS; tran_handle : PISC_TR_HANDLE;
                                   tran_name : IntPtr) : ISC_STATUS;
    function isc_rollback_retaining(status_vector : PISC_STATUS; tran_handle : PISC_TR_HANDLE): ISC_STATUS;
    function isc_rollback_savepoint(status_vector : PISC_STATUS; tran_handle : PISC_TR_HANDLE;
                                    tran_name : IntPtr; Option : UShort) : ISC_STATUS;
    function isc_rollback_transaction(status_vector : PISC_STATUS; tran_handle : PISC_TR_HANDLE): ISC_STATUS;
    function isc_start_multiple(status_vector : PISC_STATUS; tran_handle : PISC_TR_HANDLE;
                                db_handle_count : Short; teb_vector_address : PISC_TEB): ISC_STATUS;
    function isc_start_savepoint(status_vector : PISC_STATUS; tran_handle : PISC_TR_HANDLE;
                                 tran_name : IntPtr): ISC_STATUS;
    function isc_sqlcode(status_vector : PISC_STATUS): ISC_LONG;
    procedure isc_sql_interprete(sqlcode : Short; buffer : IntPtr;
                                 buffer_length : Short);
    function isc_vax_integer(buffer : IntPtr; length : Short): ISC_LONG;
    // Security Functions
    function isc_add_user(status_vector : PISC_STATUS; user_sec_data : PUserSecData): ISC_STATUS;
    function isc_delete_user(status_vector : PISC_STATUS; user_sec_data : PUserSecData): ISC_STATUS;
    function isc_modify_user(status_vector : PISC_STATUS; user_sec_data : PUserSecData): ISC_STATUS;

    // Other OSRI functions
    function isc_prepare_transaction(status_vector         : PISC_STATUS;
                                 tran_handle               : PISC_TR_HANDLE): ISC_STATUS;
   // Other Blob functions
    function BLOB_put(isc_arg1                  : char;
             isc_arg2                  : PBSTREAM): Int;
    function BLOB_get(isc_arg1                  : PBSTREAM): Int;

   // Service manager functions
   function isc_service_attach (status_vector             : PISC_STATUS;
                                 isc_arg2                  : UShort;
                                 isc_arg3                  : IntPtr;
                                 service_handle            : PISC_SVC_HANDLE;
                                 isc_arg5                  : UShort;
                                 isc_arg6                  : IntPtr): ISC_STATUS;
    function isc_service_detach(status_vector             : PISC_STATUS;
                                service_handle            : PISC_SVC_HANDLE): ISC_STATUS;
    function isc_service_query  (status_vector             : PISC_STATUS;
                                 service_handle            : PISC_SVC_HANDLE;
                                 recv_handle               : PISC_SVC_HANDLE;
                                 isc_arg4                  : UShort;
                                 isc_arg5                  : IntPtr;
                                 isc_arg6                  : UShort;
                                 isc_arg7                  : IntPtr;
                                 isc_arg8                  : UShort;
                                 isc_arg9                  : IntPtr): ISC_STATUS;
    function isc_service_start (status_vector             : PISC_STATUS;
                                service_handle            : PISC_SVC_HANDLE;
                                recv_handle               : PISC_SVC_HANDLE;
                                isc_arg4                  : UShort;
                                isc_arg5                  : IntPtr): ISC_STATUS;
    // Client information functions
    procedure isc_get_client_version(buffer : IntPtr);
    function isc_get_client_major_version: Integer;
    function isc_get_client_minor_version: Integer;
    function isc_transaction_info(status_vector            : PISC_STATUS;
                                  tran_handle               : PISC_TR_HANDLE;
                                  item_list_buffer_length   : Short;
                                  item_list_buffer          : IntPtr;
                                  result_buffer_length      : Short;
                                  result_buffer             : IntPtr): ISC_STATUS;
  end;

procedure RegisterGDSLibraryFactory(ARegisterGDSLibrary : TRegisterGDSLibrary);
begin
  FRegisterGDSLibrary := ARegisterGDSLibrary;
end;

function GetGDSLibrary : IGDSLibrary;
begin
  if not Assigned(GDSLibrary) then
    if Assigned(FRegisterGDSLibrary) then
      GDSLibrary := FRegisterGDSLibrary
    else
      GDSLibrary := TDynamicLibrary.Create;
  Result := GDSLibrary;
end;

function isc_start_savepoint_stub(status_vector : PISC_STATUS;
                                tran_handle : PISC_TR_HANDLE;
                                tran_name : IntPtr): ISC_STATUS;
begin
  raise EIBClientError.Create(Format(SIB71feature, ['isc_start_savepoint '])); {do not localize}
end;

procedure TDynamicLibrary.LoadIBLibrary;
var
  IBLibrary: THandle;
  IBXMLLibrary : THandle;

begin
  IBClientVersion := 0.0;
  IBLibrary := LoadLibrary(IBASE_DLL);
  if (IBLibrary > HINSTANCE_ERROR) then
  begin
    IBLibraryAvailable := true;
    if GetProcAddress(IBLibrary, 'isc_get_client_version') <> nil then {do not localize}
      IBClientVersion := _isc_get_client_major_version + (_isc_get_client_minor_version / 10);
    if IBClientVersion = 0 then
    begin
      if GetProcAddress(IBLibrary, 'isc_rollback_retaining') <> nil then {do not localize}
        IBClientVersion := 6.0
      else
        IBClientVersion := 5.0;
    end;
    FreeLibrary(IBLibrary);
  end
  else
    IBLibraryAvailable := false;

  IBXMLLibrary := LoadLibrary(String(IBXML_DLL));
  if (IBXMLLibrary > HINSTANCE_ERROR) then
  begin
    IBXMLLibraryAvailable := true;
    FreeLibrary(IBXMLLibrary);
  end
  else
    IBXMLLibraryAvailable := false;
end;

function TDynamicLibrary.TryIBLoad: Boolean;
begin
  if (not IBLibraryAvailable) then
    LoadIBLibrary;
  result := IBLibraryAvailable;
end;

procedure TDynamicLibrary.CheckIBLoaded;
begin
  if not TryIBLoad then
    IBError(ibxeInterBaseMissing, [nil]);
end;

function TDynamicLibrary.GetIBClientVersion: Currency;
begin
  CheckIBLoaded;
  result := IBClientVersion;
end;

{ TDynamicLibrary }

function TDynamicLibrary.BLOB_put(isc_arg1: char; isc_arg2: PBSTREAM): Int;
begin
  Result := _BLOB_put(isc_arg1, isc_arg2);
end;

function TDynamicLibrary.isc_add_user(status_vector: PISC_STATUS;
  user_sec_data: PUserSecData): ISC_STATUS;
begin
  Result := _isc_add_user(status_vector, user_sec_data);
end;

function TDynamicLibrary.isc_array_gen_sdl2(status_vector: PISC_STATUS;
  isc_array_desc: PISC_ARRAY_DESC_V2; isc_arg3: PShort; isc_arg4: IntPtr;
  isc_arg5: PShort): ISC_STATUS;
begin
  if IBClientVersion >= 7 then
    Result := _isc_array_gen_sdl2(status_vector, isc_array_desc, isc_arg3, isc_arg4, isc_arg5)
  else
    raise EIBClientError.Create(Format(SIB70feature, ['isc_array_gen_sdl2'])); {do not localize}
end;

function TDynamicLibrary.isc_array_get_slice(status_vector: PISC_STATUS;
  db_handle: PISC_DB_HANDLE; trans_handle: PISC_TR_HANDLE;
  array_id: PISC_QUAD; descriptor: PISC_ARRAY_DESC; dest_array: IntPtr;
  slice_length: ISC_LONG): ISC_STATUS;
begin
  Result := _isc_array_get_slice(status_vector, db_handle, trans_handle,
               array_id, descriptor, dest_array, slice_length);
end;

function TDynamicLibrary.isc_array_get_slice2(status_vector: PISC_STATUS;
  db_handle: PISC_DB_HANDLE; trans_handle: PISC_TR_HANDLE;
  array_id: PISC_QUAD; descriptor: PISC_ARRAY_DESC_V2; dest_array: IntPtr;
  slice_length: ISC_LONG): ISC_STATUS;
begin
  if IBClientVersion >= 7 then
    Result := _isc_array_get_slice2(status_vector, db_handle, trans_handle,
                 array_id, descriptor, dest_array, slice_length)
  else
    raise EIBClientError.Create(Format(SIB70feature, ['isc_array_get_slice2'])); {do not localize}
end;

function TDynamicLibrary.isc_array_lookup_bounds(
  status_vector: PISC_STATUS; db_handle: PISC_DB_HANDLE;
  trans_handle: PISC_TR_HANDLE; table_name, column_name: IntPtr;
  descriptor: PISC_ARRAY_DESC): ISC_STATUS;
begin
  Result := _isc_array_lookup_bounds(status_vector, db_handle,
                   trans_handle, table_name, column_name, descriptor);
end;

function TDynamicLibrary.isc_array_lookup_bounds2(
  status_vector: PISC_STATUS; db_handle: PISC_DB_HANDLE;
  trans_handle: PISC_TR_HANDLE; table_name, column_name: IntPtr;
  descriptor: PISC_ARRAY_DESC_V2): ISC_STATUS;
begin
  if IBClientVersion >= 7 then
    Result := _isc_array_lookup_bounds2(status_vector, db_handle,
          trans_handle, table_name, column_name, descriptor)
  else
    raise EIBClientError.Create(Format(SIB70feature, ['isc_array_lookup_bounds2'])); {do not localize}
end;

function TDynamicLibrary.isc_array_lookup_desc(status_vector: PISC_STATUS;
  db_handle: PISC_DB_HANDLE; trans_handle: PISC_TR_HANDLE; table_name,
  column_name: IntPtr; descriptor: PISC_ARRAY_DESC): ISC_STATUS;
begin
  Result := _isc_array_lookup_desc(status_vector, db_handle, trans_handle,
            table_name, column_name, descriptor);
end;

function TDynamicLibrary.isc_array_lookup_desc2(status_vector: PISC_STATUS;
  db_handle: PISC_DB_HANDLE; trans_handle: PISC_TR_HANDLE; table_name,
  column_name: IntPtr; descriptor: PISC_ARRAY_DESC_V2): ISC_STATUS;
begin
  if IBClientVersion >= 7 then
    Result := _isc_array_lookup_desc2(status_vector, db_handle, trans_handle,
            table_name, column_name, descriptor)
  else
    raise EIBClientError.Create(Format(SIB70feature, ['isc_array_lookup_desc2 '])); {do not localize}
end;

function TDynamicLibrary.isc_array_put_slice(status_vector: PISC_STATUS;
  db_handle: PISC_DB_HANDLE; trans_handle: PISC_TR_HANDLE;
  array_id: PISC_QUAD; descriptor: PISC_ARRAY_DESC; source_array: IntPtr;
  slice_length: PISC_LONG): ISC_STATUS;
begin
  Result := _isc_array_put_slice(status_vector, db_handle, trans_handle,
                    array_id, descriptor, source_array, slice_length);
end;

function TDynamicLibrary.isc_array_put_slice2(status_vector: PISC_STATUS;
  db_handle: PISC_DB_HANDLE; trans_handle: PISC_TR_HANDLE;
  array_id: PISC_QUAD; descriptor: PISC_ARRAY_DESC_V2; source_array: IntPtr;
  slice_length: PISC_LONG): ISC_STATUS;
begin
  if IBClientVersion >= 7 then
    Result := _isc_array_put_slice2(status_vector, db_handle, trans_handle,
                array_id, descriptor, source_array, slice_length)
  else
    raise EIBClientError.Create(Format(SIB70feature, ['isc_array_put_slice2 '])); {do not localize}
end;

function TDynamicLibrary.isc_array_set_desc(status_vector: PISC_STATUS;
  table_name, column_name: IntPtr; sql_dtype, sql_length,
  sql_dimensions: PShort; descriptor: PISC_ARRAY_DESC): ISC_STATUS;
begin
  Result := _isc_array_set_desc(status_vector, table_name, column_name,
                sql_dtype, sql_length, sql_dimensions, descriptor);
end;

function TDynamicLibrary.isc_array_set_desc2(status_vector: PISC_STATUS;
  table_name, column_name: IntPtr; sql_dtype, sql_length,
  sql_dimensions: PShort; descriptor: PISC_ARRAY_DESC_V2): ISC_STATUS;
begin
  if IBClientVersion >= 7 then
    Result := _isc_array_set_desc2(status_vector, table_name, column_name,
             sql_dtype, sql_length, sql_dimensions, descriptor)
  else
    raise EIBClientError.Create(Format(SIB70feature, ['isc_array_set_desc2 '])); {do not localize}
end;

function TDynamicLibrary.isc_attach_database(status_vector: PISC_STATUS;
  db_name_length: Short; db_name: IntPtr; db_handle: PISC_DB_HANDLE;
  parm_buffer_length: Short; parm_buffer: IntPtr): ISC_STATUS;
begin
  Result := _isc_attach_database(status_vector, db_name_length, db_name,
              db_handle, parm_buffer_length, parm_buffer);
end;

procedure TDynamicLibrary.isc_blob_default_desc(descriptor: PISC_BLOB_DESC;
  table_name, column_name: PUChar);
begin
  _isc_blob_default_desc(descriptor, table_name, column_name);
end;

procedure TDynamicLibrary.isc_blob_default_desc2(
  descriptor: PISC_BLOB_DESC_V2; table_name, column_name: PUChar);
begin
  if IBClientVersion >= 7 then
    _isc_blob_default_desc2(descriptor, table_name, column_name)
  else
    raise EIBClientError.Create(Format(SIB70feature, ['isc_blob_default_desc2 '])); {do not localize}
end;

function TDynamicLibrary.isc_blob_gen_bpb(status_vector: PISC_STATUS;
  to_descriptor, from_descriptor: PISC_BLOB_DESC;
  bpb_buffer_length: UShort; bpb_buffer: PUChar;
  bpb_length: PUShort): ISC_STATUS;
begin
  Result := _isc_blob_gen_bpb(status_vector, to_descriptor, from_descriptor,
               bpb_buffer_length, bpb_buffer, bpb_length);
end;

function TDynamicLibrary.isc_blob_gen_bpb2(status_vector: PISC_STATUS;
  to_descriptor, from_descriptor: PISC_BLOB_DESC_V2;
  bpb_buffer_length: UShort; bpb_buffer: PUChar;
  bpb_length: PUShort): ISC_STATUS;
begin
  if IBClientVersion >= 7 then
    Result := _isc_blob_gen_bpb2(status_vector, to_descriptor, from_descriptor,
           bpb_buffer_length, bpb_buffer, bpb_length)
  else
    raise EIBClientError.Create(Format(SIB70feature, ['isc_blob_gen_bpb2 '])); {do not localize}
end;

function TDynamicLibrary.isc_blob_info(status_vector: PISC_STATUS;
  blob_handle: PISC_BLOB_HANDLE; item_list_buffer_length: Short;
  item_list_buffer: IntPtr; result_buffer_length: Short;
  result_buffer: IntPtr): ISC_STATUS;
begin
  Result := _isc_blob_info(status_vector, blob_handle, item_list_buffer_length,
                 item_list_buffer, result_buffer_length, result_buffer);
end;

function TDynamicLibrary.isc_blob_lookup_desc(status_vector: PISC_STATUS;
  db_handle: PISC_DB_HANDLE; trans_handle: PISC_TR_HANDLE; table_name,
  column_name: IntPtr; descriptor: PISC_BLOB_DESC;
  global: PUChar): ISC_STATUS;
begin
  Result := _isc_blob_lookup_desc(status_vector, db_handle, trans_handle,
                   table_name, column_name, descriptor, global);
end;

function TDynamicLibrary.isc_blob_lookup_desc2(status_vector: PISC_STATUS;
  db_handle: PISC_DB_HANDLE; trans_handle: PISC_TR_HANDLE; table_name,
  column_name: IntPtr; descriptor: PISC_BLOB_DESC_v2;
  global: PUChar): ISC_STATUS;
begin
  if IBClientVersion >= 7 then
    Result := _isc_blob_lookup_desc2(status_vector, db_handle, trans_handle,
                table_name, column_name, descriptor, global)
  else
    raise EIBClientError.Create(Format(SIB70feature, ['isc_blob_lookup_desc2 '])); {do not localize}
end;

function TDynamicLibrary.isc_blob_set_desc(status_vector: PISC_STATUS;
  table_name, column_name: IntPtr; subtype, charset, segment_size: Short;
  descriptor: PISC_BLOB_DESC): ISC_STATUS;
begin
  Result := _isc_blob_set_desc(status_vector, table_name, column_name, subtype,
                charset, segment_size, descriptor);
end;

function TDynamicLibrary.isc_blob_set_desc2(status_vector: PISC_STATUS;
  table_name, column_name: IntPtr; subtype, charset, segment_size: Short;
  descriptor: PISC_BLOB_DESC_V2): ISC_STATUS;
begin
  if IBClientVersion >= 7 then
    Result := _isc_blob_set_desc2(status_vector, table_name, column_name, subtype,
                   charset, segment_size, descriptor)
  else
    raise EIBClientError.Create(Format(SIB70feature, ['isc_blob_set_desc2 '])); {do not localize}
end;

function TDynamicLibrary.isc_cancel_blob(status_vector: PISC_STATUS;
  blob_handle: PISC_BLOB_HANDLE): ISC_STATUS;
begin
  Result := _isc_cancel_blob(status_vector, blob_handle);
end;

function TDynamicLibrary.isc_cancel_events(status_vector: PISC_STATUS;
  db_handle: PISC_DB_HANDLE; event_id: PISC_LONG): ISC_STATUS;
begin
  Result := _isc_cancel_events(status_vector, db_handle, event_id);
end;

function TDynamicLibrary.isc_close_blob(status_vector: PISC_STATUS;
  blob_handle: PISC_BLOB_HANDLE): ISC_STATUS;
begin
  Result := _isc_close_blob(status_vector, blob_handle);
end;

function TDynamicLibrary.isc_commit_retaining(status_vector: PISC_STATUS;
  tran_handle: PISC_TR_HANDLE): ISC_STATUS;
begin
  Result := _isc_commit_retaining(status_vector, tran_handle);
end;

function TDynamicLibrary.isc_commit_transaction(status_vector: PISC_STATUS;
  tran_handle: PISC_TR_HANDLE): ISC_STATUS;
begin
  Result := _isc_commit_transaction(status_vector, tran_handle);
end;

function TDynamicLibrary.isc_create_blob2(status_vector: PISC_STATUS;
  db_handle: PISC_DB_HANDLE; tran_handle: PISC_TR_HANDLE;
  blob_handle: PISC_BLOB_HANDLE; blob_id: PISC_QUAD; bpb_length: Short;
  bpb_address: IntPtr): ISC_STATUS;
begin
  Result := _isc_create_blob2(status_vector, db_handle, tran_handle,
                 blob_handle, blob_id, bpb_length, bpb_address);
end;

function TDynamicLibrary.isc_database_info(status_vector: PISC_STATUS;
  db_handle: PISC_DB_HANDLE; item_list_buffer_length: Short;
  item_list_buffer: IntPtr; result_buffer_length: Short;
  result_buffer: IntPtr): ISC_STATUS;
begin
  Result := _isc_database_info(status_vector, db_handle, item_list_buffer_length,
                item_list_buffer, result_buffer_length, result_buffer);
end;

procedure TDynamicLibrary.isc_decode_date(ib_date: PISC_QUAD;
  var tm_date: TCTimeStructure);
begin
  _isc_decode_date(ib_date, tm_date);
end;

procedure TDynamicLibrary.isc_decode_sql_date(ib_date: PISC_DATE;
  var tm_date: TCTimeStructure);
begin
  if IBClientVersion >= 6 then
    _isc_decode_sql_date(ib_date, tm_date)
  else
    IBError(ibxeIB60feature, ['isc_decode_sql_date']); {do not localize}
end;

procedure TDynamicLibrary.isc_decode_sql_time(ib_time: PISC_TIME;
  var tm_date: TCTimeStructure);
begin
  if IBClientVersion >= 6 then
    _isc_decode_sql_time(ib_time, tm_date)
  else
    IBError(ibxeIB60feature, ['isc_decode_sql_time']); {do not localize}
end;

procedure TDynamicLibrary.isc_decode_timestamp(
  ib_timestamp: PISC_TIMESTAMP; tm_date: PCTimeStructure);
begin
  if IBClientVersion >= 6 then
    _isc_decode_timestamp(ib_timestamp, tm_date)
  else
    IBError(ibxeIB60feature, ['isc_decode_timestamp']); {do not localize}
end;

function TDynamicLibrary.isc_delete_user(status_vector: PISC_STATUS;
  user_sec_data: PUserSecData): ISC_STATUS;
begin
  Result := _isc_delete_user(status_vector, user_sec_data);
end;

function TDynamicLibrary.isc_detach_database(status_vector: PISC_STATUS;
  db_handle: PISC_DB_HANDLE): ISC_STATUS;
begin
  Result := _isc_detach_database(status_vector, db_handle);
end;

function TDynamicLibrary.isc_drop_database(status_vector: PISC_STATUS;
  db_handle: PISC_DB_HANDLE): ISC_STATUS;
begin
  Result := _isc_drop_database(status_vector, db_handle);
end;

function TDynamicLibrary.isc_dsql_alloc_statement2(
  status_vector: PISC_STATUS; db_handle: PISC_DB_HANDLE;
  stmt_handle: PISC_STMT_HANDLE): ISC_STATUS;
begin
  Result := _isc_dsql_alloc_statement2( status_vector, db_handle, stmt_handle);
end;

function TDynamicLibrary.isc_dsql_describe(status_vector: PISC_STATUS;
  stmt_handle: PISC_STMT_HANDLE; dialect: UShort;
  xsqlda: PXSQLDA): ISC_STATUS;
begin
  Result := _isc_dsql_describe(status_vector, stmt_handle, dialect, xsqlda);
end;

function TDynamicLibrary.isc_dsql_describe_bind(status_vector: PISC_STATUS;
  stmt_handle: PISC_STMT_HANDLE; dialect: UShort;
  xsqlda: PXSQLDA): ISC_STATUS;
begin
  Result := _isc_dsql_describe_bind(status_vector, stmt_handle, dialect,
                  xsqlda);
end;

function TDynamicLibrary.isc_dsql_execute(status_vector: PISC_STATUS;
  tran_handle: PISC_TR_HANDLE; stmt_handle: PISC_STMT_HANDLE;
  dialect: UShort; xsqlda: PXSQLDA): ISC_STATUS;
begin
  Result := _isc_dsql_execute(status_vector, tran_handle, stmt_handle,
              dialect, xsqlda);
end;

function TDynamicLibrary.isc_dsql_execute_immediate(
  status_vector: PISC_STATUS; db_handle: PISC_DB_HANDLE;
  tran_handle: PISC_TR_HANDLE; length: UShort; statement: IntPtr;
  dialect: UShort; xsqlda: PXSQLDA): ISC_STATUS;
begin
  Result := _isc_dsql_execute_immediate(status_vector, db_handle,
               tran_handle, length, statement, dialect, xsqlda);
end;

function TDynamicLibrary.isc_dsql_execute2(status_vector: PISC_STATUS;
  tran_handle: PISC_TR_HANDLE; stmt_handle: PISC_STMT_HANDLE;
  dialect: UShort; in_xsqlda, out_xsqlda: PXSQLDA): ISC_STATUS;
begin
  Result := _isc_dsql_execute2(status_vector, tran_handle, stmt_handle,
                dialect, in_xsqlda, out_xsqlda);
end;

function TDynamicLibrary.isc_dsql_fetch(status_vector: PISC_STATUS;
  stmt_handle: PISC_STMT_HANDLE; dialect: UShort;
  xsqlda: PXSQLDA): ISC_STATUS;
begin
  Result := _isc_dsql_fetch(status_vector, stmt_handle, dialect, xsqlda);
end;

function TDynamicLibrary.isc_dsql_free_statement(
  status_vector: PISC_STATUS; stmt_handle: PISC_STMT_HANDLE;
  options: UShort): ISC_STATUS;
begin
  Result := _isc_dsql_free_statement(status_vector, stmt_handle, options);
end;

function TDynamicLibrary.isc_dsql_prepare(status_vector: PISC_STATUS;
  tran_handle: PISC_TR_HANDLE; stmt_handle: PISC_STMT_HANDLE;
  length: UShort; statement: IntPtr; dialect: UShort;
  xsqlda: PXSQLDA): ISC_STATUS;
begin
  Result := _isc_dsql_prepare(status_vector, tran_handle, stmt_handle,
                    length, statement, dialect, xsqlda);
end;

function TDynamicLibrary.isc_dsql_set_cursor_name(
  status_vector: PISC_STATUS; stmt_handle: PISC_STMT_HANDLE;
  cursor_name: IntPtr; _type: UShort): ISC_STATUS;
begin
  Result := _isc_dsql_set_cursor_name(status_vector, stmt_handle, cursor_name,
                       _type);
end;

function TDynamicLibrary.isc_dsql_sql_info(status_vector: PISC_STATUS;
  stmt_handle: PISC_STMT_HANDLE; item_length: Short; items: IntPtr;
  buffer_length: Short; buffer: IntPtr): ISC_STATUS;
begin
  Result := _isc_dsql_sql_info(status_vector, stmt_handle, item_length, items,
                buffer_length, buffer);
end;

procedure TDynamicLibrary.isc_encode_date(var tm_date: TCTimeStructure;
  ib_date: PISC_QUAD);
begin
  _isc_encode_date(tm_date, ib_date);
end;

procedure TDynamicLibrary.isc_encode_sql_date(var tm_date: TCTimeStructure;
  ib_date: PISC_DATE);
begin
  if IBClientVersion >= 6 then
    _isc_encode_sql_date(tm_date, ib_date)
  else
    IBError(ibxeIB60feature, ['isc_encode_sql_date']); {do not localize}
end;

procedure TDynamicLibrary.isc_encode_sql_time(var tm_date: TCTimeStructure;
  ib_time: PISC_TIME);
begin
  if IBClientVersion >= 6 then
    _isc_encode_sql_time(tm_date, ib_time)
  else
    IBError(ibxeIB60feature, ['isc_encode_sql_time']); {do not localize}
end;

procedure TDynamicLibrary.isc_encode_timestamp(tm_date: PCTimeStructure;
  ib_timestamp: PISC_TIMESTAMP);
begin
  if IBClientVersion >= 6 then
    _isc_encode_timestamp(tm_date, ib_timestamp)
  else
    IBError(ibxeIB60feature, ['isc_encode_sql_timestamp']); {do not localize}
end;

type
  Tsib_event_block = function (EventBuffer, ResultBuffer: PPChar; IDCount: UShort;
    Event1, Event2, Event3, Event4, Event5, Event6, Event7, Event8, Event9,
    Event10, Event11, Event12, Event13, Event14, Event15: IntPtr): ISC_LONG; cdecl;


function TDynamicLibrary.isc_event_block(event_buffer,
  result_buffer: PPChar; id_count: UShort;
  event_list: array of IntPtr): ISC_LONG;
begin
{  Result := Tsib_event_block(_isc_event_block)(event_buffer, result_buffer,
    id_count, event_list[0], event_list[1], event_list[2], event_list[3],
    event_list[4], event_list[5], event_list[6], event_list[7], event_list[8],
    event_list[9], event_list[10], event_list[11], event_list[12],
    event_list[13], event_list[14]); }
  Result := 0;
end;

procedure TDynamicLibrary.isc_event_counts(status_vector: PISC_STATUS;
  buffer_length: Short; event_buffer, result_buffer: IntPtr);
begin
  _isc_event_counts(status_vector, buffer_length, event_buffer, result_buffer);
end;

function TDynamicLibrary.isc_free(isc_arg1: IntPtr): ISC_LONG;
begin
  Result := _isc_free(isc_arg1);
end;

function TDynamicLibrary.isc_get_client_major_version: Integer;
begin
  if IBClientVersion >= 7 then
    Result := _isc_get_client_major_version
  else
    raise EIBClientError.Create(Format(SIB70feature, ['isc_get_client_major_version'])); {do not localize}
end;

function TDynamicLibrary.isc_get_client_minor_version: Integer;
begin
  if IBClientVersion >= 7 then
    Result := _isc_get_client_minor_version
  else
    raise EIBClientError.Create(Format(SIB70feature, ['isc_get_client_minor_version'])); {do not localize}
end;

procedure TDynamicLibrary.isc_get_client_version(buffer: IntPtr);
begin
  if IBClientVersion >= 7 then
    _isc_get_client_version(buffer)
  else
    raise EIBClientError.Create(Format(SIB70feature, ['isc_get_client_version'])); {do not localize}
end;

function TDynamicLibrary.isc_get_segment(status_vector: PISC_STATUS;
  blob_handle: PISC_BLOB_HANDLE; actual_seg_length: PUShort;
  seg_buffer_length: UShort; seg_buffer: IntPtr): ISC_STATUS;
begin
  Result := _isc_get_segment(status_vector, blob_handle, actual_seg_length,
              seg_buffer_length, seg_buffer);
end;

function TDynamicLibrary.isc_interprete(buffer: IntPtr;
  status_vector: PPISC_STATUS): ISC_STATUS;
begin
  Result := _isc_interprete(buffer, status_vector);
end;

function TDynamicLibrary.isc_modify_user(status_vector: PISC_STATUS;
  user_sec_data: PUserSecData): ISC_STATUS;
begin
  Result := _isc_modify_user(status_vector, user_sec_data);
end;

function TDynamicLibrary.isc_open_blob2(status_vector: PISC_STATUS;
  db_handle: PISC_DB_HANDLE; tran_handle: PISC_TR_HANDLE;
  blob_handle: PISC_BLOB_HANDLE; blob_id: PISC_QUAD; bpb_length: Short;
  bpb_buffer: IntPtr): ISC_STATUS;
begin
  Result := _isc_open_blob2(status_vector, db_handle, tran_handle,
              blob_handle, blob_id, bpb_length, bpb_buffer);
end;

function TDynamicLibrary.isc_prepare_transaction(
  status_vector: PISC_STATUS; tran_handle: PISC_TR_HANDLE): ISC_STATUS;
begin
  Result := _isc_prepare_transaction(status_vector, tran_handle);
end;

function TDynamicLibrary.isc_prepare_transaction2(
  status_vector: PISC_STATUS; tran_handle: PISC_TR_HANDLE;
  msg_length: Short; msg: IntPtr): ISC_STATUS;
begin
  Result := _isc_prepare_transaction2(status_vector, tran_handle, msg_length, msg);
end;

function TDynamicLibrary.isc_put_segment(status_vector: PISC_STATUS;
  blob_handle: PISC_BLOB_HANDLE; seg_buffer_len: UShort;
  seg_buffer: IntPtr): ISC_STATUS;
begin
  Result := _isc_put_segment(status_vector, blob_handle, seg_buffer_len, seg_buffer);
end;

function TDynamicLibrary.isc_que_events(status_vector: PISC_STATUS;
  db_handle: PISC_DB_HANDLE; event_id: PISC_LONG; length: Short;
  event_buffer: IntPtr; event_function: TISC_CALLBACK;
  event_function_arg: IntPtr): ISC_STATUS;
begin
  Result := _isc_que_events(status_vector, db_handle, event_id, length,
            event_buffer, event_function, event_function_arg);
end;

function TDynamicLibrary.isc_release_savepoint(status_vector: PISC_STATUS;
  tran_handle: PISC_TR_HANDLE; tran_name: IntPtr): ISC_STATUS;
begin
  if IBClientVersion >= 7.1 then
    Result := _isc_release_savepoint(status_vector, tran_handle, tran_name)
  else
    raise EIBClientError.Create(Format(SIB71feature, ['isc_release_savepoint '])); {do not localize}
end;

function TDynamicLibrary.isc_rollback_retaining(status_vector: PISC_STATUS;
  tran_handle: PISC_TR_HANDLE): ISC_STATUS;
begin
  Result := 0;
  if IBClientVersion >= 6 then
    Result := _isc_rollback_retaining(status_vector, tran_handle)
  else
    IBError(ibxeIB60feature, ['isc_rollback_retaining']); {do not localize}
end;

function TDynamicLibrary.isc_rollback_savepoint(status_vector: PISC_STATUS;
  tran_handle: PISC_TR_HANDLE; tran_name: IntPtr;
  Option: UShort): ISC_STATUS;
begin
  if IBClientVersion >= 7.1 then
    Result := _isc_rollback_savepoint(status_vector, tran_handle, tran_name,
               Option)
  else
    raise EIBClientError.Create(Format(SIB71feature, ['isc_rollback_savepoint '])); {do not localize}
end;

function TDynamicLibrary.isc_rollback_transaction(
  status_vector: PISC_STATUS; tran_handle: PISC_TR_HANDLE): ISC_STATUS;
begin
  Result := _isc_rollback_transaction(status_vector, tran_handle);
end;

function TDynamicLibrary.isc_service_attach(status_vector: PISC_STATUS;
  isc_arg2: UShort; isc_arg3: IntPtr; service_handle: PISC_SVC_HANDLE;
  isc_arg5: UShort; isc_arg6: IntPtr): ISC_STATUS;
begin
  Result := 0;
  if IBClientVersion >= 6 then
    Result := _isc_service_attach(status_vector, isc_arg2, isc_arg3,
               service_handle, isc_arg5, isc_arg6)
  else
    IBError(ibxeIB60feature, ['isc_service_attach']); {do not localize}
end;

function TDynamicLibrary.isc_service_detach(status_vector: PISC_STATUS;
  service_handle: PISC_SVC_HANDLE): ISC_STATUS;
begin
  Result := 0;
  if IBClientVersion >= 6 then
    Result := _isc_service_detach(status_vector, service_handle)
  else
    IBError(ibxeIB60feature, ['isc_service_detach']); {do not localize}
end;

function TDynamicLibrary.isc_service_query(status_vector: PISC_STATUS;
  service_handle, recv_handle: PISC_SVC_HANDLE; isc_arg4: UShort;
  isc_arg5: IntPtr; isc_arg6: UShort; isc_arg7: IntPtr; isc_arg8: UShort;
  isc_arg9: IntPtr): ISC_STATUS;
begin
  Result := 0;
  if IBClientVersion >= 6 then
    Result := _isc_service_query(status_vector, service_handle, recv_handle,
               isc_arg4, isc_arg5, isc_arg6, isc_arg7, isc_arg8, isc_arg9)
  else
    IBError(ibxeIB60feature, ['isc_service_query']); {do not localize}
end;

function TDynamicLibrary.isc_service_start(status_vector: PISC_STATUS;
  service_handle, recv_handle: PISC_SVC_HANDLE; isc_arg4: UShort;
  isc_arg5: IntPtr): ISC_STATUS;
begin
  Result := 0;
  if IBClientVersion >= 6 then
    Result := _isc_service_start(status_vector, service_handle, recv_handle,
             isc_arg4, isc_arg5)
  else
    IBError(ibxeIB60feature, ['isc_service_start']); {do not localize}
end;

procedure TDynamicLibrary.isc_sql_interprete(sqlcode: Short; buffer: IntPtr;
  buffer_length: Short);
begin
   _isc_sql_interprete(sqlcode, buffer, buffer_length);
end;

function TDynamicLibrary.isc_sqlcode(status_vector: PISC_STATUS): ISC_LONG;
begin
  Result := _isc_sqlcode(status_vector);
end;

function TDynamicLibrary.isc_start_multiple(status_vector: PISC_STATUS;
  tran_handle: PISC_TR_HANDLE; db_handle_count: Short;
  teb_vector_address: PISC_TEB): ISC_STATUS;
begin
  Result := _isc_start_multiple(status_vector, tran_handle, db_handle_count,
               teb_vector_address);
end;

function TDynamicLibrary.isc_start_savepoint(status_vector: PISC_STATUS;
  tran_handle: PISC_TR_HANDLE; tran_name: IntPtr): ISC_STATUS;
begin
  if IBClientVersion >= 7.1 then
    Result := _isc_start_savepoint(status_vector, tran_handle, tran_name)
  else
    raise EIBClientError.Create(Format(SIB71feature, ['isc_start_savepoint '])); {do not localize}
end;

function TDynamicLibrary.isc_vax_integer(buffer: IntPtr;
  length: Short): ISC_LONG;
begin
  Result := _isc_vax_integer(buffer, length);
end;

function TDynamicLibrary.BLOB_get(isc_arg1: PBSTREAM): Int;
begin
  Result := _BLOB_get(isc_arg1);
end;

function TDynamicLibrary.isc_transaction_info(status_vector: PISC_STATUS;
  tran_handle: PISC_TR_HANDLE; item_list_buffer_length: Short;
  item_list_buffer: IntPtr; result_buffer_length: Short;
  result_buffer: IntPtr): ISC_STATUS;
begin
  Result := _isc_transaction_info(status_vector, tran_handle,
                   item_list_buffer_length, item_list_buffer,
                   result_buffer_length, result_buffer);
end;

initialization

finalization
  GDSLibrary := nil;
end.
